// Forerunner Protocol Content Script

// Inject Forerunner API into the page
(function() {
  window.ForerunnerProtocol = {
    connect: async function(sessionId, validatorUrl = 'wss://test.forerunnerprotocol.xyz/ws') {
      return new Promise((resolve, reject) => {
        chrome.runtime.sendMessage({
          type: 'CONNECT',
          data: { sessionId, validatorUrl }
        }, response => {
          if (response.success) {
            resolve(response);
          } else {
            reject(new Error(response.error));
          }
        });
      });
    },

    sendMessage: async function(sessionId, message) {
      return new Promise((resolve, reject) => {
        chrome.runtime.sendMessage({
          type: 'SEND_MESSAGE',
          data: { sessionId, message }
        }, response => {
          if (response.success) {
            resolve(response);
          } else {
            reject(new Error(response.error));
          }
        });
      });
    },

    disconnect: async function(sessionId) {
      return new Promise((resolve, reject) => {
        chrome.runtime.sendMessage({
          type: 'DISCONNECT',
          data: { sessionId }
        }, response => {
          if (response.success) {
            resolve(response);
          } else {
            reject(new Error(response.error));
          }
        });
      });
    },

    getMetrics: async function() {
      return new Promise((resolve, reject) => {
        chrome.runtime.sendMessage({
          type: 'GET_METRICS'
        }, response => {
          if (response.success) {
            resolve(response.data);
          } else {
            reject(new Error(response.error));
          }
        });
      });
    }
  };

  // Listen for messages from background script
  chrome.runtime.onMessage.addListener((message, sender, sendResponse) => {
    if (message.type === 'FORERUNNER_MESSAGE') {
      // Dispatch custom event for the page to listen to
      window.dispatchEvent(new CustomEvent('forerunner:message', {
        detail: {
          sessionId: message.sessionId,
          data: message.data
        }
      }));
    }
  });

  console.log('Forerunner Protocol injected');
})();
