// Popup script for Forerunner Protocol extension

async function updateMetrics() {
  try {
    const response = await chrome.runtime.sendMessage({ type: 'GET_METRICS' });

    if (response.success) {
      const metrics = response.data;

      document.getElementById('sessions').textContent = metrics.sessions;
      document.getElementById('sent').textContent = metrics.messagesSent;
      document.getElementById('received').textContent = metrics.messagesReceived;
      document.getElementById('bytes-sent').textContent = (metrics.bytesSent / 1024).toFixed(2) + ' KB';
      document.getElementById('bytes-received').textContent = (metrics.bytesReceived / 1024).toFixed(2) + ' KB';

      if (metrics.sessions > 0) {
        document.getElementById('status').textContent = 'Connected';
        document.getElementById('status').classList.add('connected');
      }
    }
  } catch (error) {
    console.error('Error updating metrics:', error);
  }
}

// Update metrics when popup opens
updateMetrics();

// Update metrics every 2 seconds
setInterval(updateMetrics, 2000);
